// Show |url| in a new tab.
function showUrl(id,closewindow) {
	var settings = JSON.parse(localStorage.settings);
	
	var splitValue = localStorage["ClosedTab-"+id].split("%%");
	var url = splitValue[2];
	delete localStorage["ClosedTab-"+id];
	localStorage["closedTabCount"] --;
	setBadge();

	if (closewindow==true){
		chrome.tabs.create({"url": url,"selected":true});  
		window.close();
	}else{
		chrome.tabs.create({"url": url,"selected":false});  
	}
}

function setBadge() {
	var settings = JSON.parse(localStorage.settings);
	var n = localStorage.closedTabCount;
	if (parseInt(n,10) > 0 && settings.showBadge){
		chrome.browserAction.setBadgeBackgroundColor({color:[15, 161, 211, 255]});
		chrome.browserAction.setBadgeText({text: n});
	}else{
		chrome.browserAction.setBadgeText({text: ""});
	}
}

function resetData() {	
	//console.log("RESET");
	var settings = JSON.parse(localStorage.settings);
	localStorage.clear();
	
	localStorage.minimumTabInc = 0;
	localStorage.uniqueTabInc = 1;
	localStorage.closedTabCount = 0;
	localStorage.settings = JSON.stringify(settings);

	setBadge();
	
	/*chrome.tabs.getAllInWindow(null, function(tabsInWindow) {
		for (var i=0; i<tabsInWindow.length; i++) {
			AddNewTab(tabsInWindow[i].id,null, tabsInWindow[i]);
		}
	});*/
}

function updateIcon() {
	var settings = JSON.parse(localStorage["settings"]);
	
	if(settings.altBut){
		chrome.browserAction.setIcon({path:"icon-19-1.png"});
	}else{
		chrome.browserAction.setIcon({path:"icon-19-0.png"});
	}
}